#include "Socket.h"

void CSocketBase::ZainicjujWinsock(const int typ)
{
	WSADATA wsaData;
	WORD wersja = MAKEWORD( 2, 0 );
	int blad = WSAStartup(wersja, &wsaData );
	if(blad != 0)
	{
		MessageBox(0,L"Bd wczytywania biblioteki gniazda",L"",MB_OK);
		return ;
	}
	if((mojSocket = socket( AF_INET, typ, IPPROTO_IP )) == SOCKET_ERROR)
	{
		MessageBox(0,L"Bd tworzenia gniazda",L"",MB_OK);
		return ;
	}
}

void CSocketBase::ZamknijGniazdo()
{
	shutdown(mojSocket,SD_BOTH);
	closesocket(mojSocket);
}

int CSocketClientTCP::Wyslij(const char * serwer,  const int port, const char * dane, int dlugosc)
{
    hostent *host;
	sockaddr_in sin;
	memset( &sin, 0, sizeof(sin));

	host=gethostbyname(serwer);

	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = ((struct in_addr *)(host->h_addr))->s_addr;
	sin.sin_port = htons(port); 

    connect(mojSocket,(const sockaddr*)&sin,sizeof(sin));

    int n = send(mojSocket,dane,dlugosc,0);

    return n;
}

void CSocketServerTCP::OdbierzDane(const int port, CEdit & edit)
{
     sockaddr_in sin;
     sockaddr_in klientAdr;
     int rozmiar = sizeof(klientAdr);
     char bufor[1024];
	 wchar_t buforWide[1024];

     sin.sin_addr.s_addr = htonl(INADDR_ANY);
     sin.sin_family = AF_INET;
     sin.sin_port = htons(port);

     if(bind(mojSocket,(const sockaddr*)&sin,sizeof(sin)) == SOCKET_ERROR)
	 {
		 MessageBox(0,L"Bd funkcji bind",L"",MB_OK);
		 return ;
	 }

     listen(mojSocket,5);

     SOCKET klientSocket = accept(mojSocket,(sockaddr*)&klientAdr,&rozmiar);

     if(klientSocket == INVALID_SOCKET)
     {		 
         MessageBox(0,L"Niepoprawne gniazdo klienta",L"",MB_OK);
         return;
     }

     int n = recv(klientSocket,bufor,sizeof(bufor),0);

	 mbstowcs(buforWide,bufor,n);

	 edit.SetWindowTextW(buforWide);
}

int CSocketClientUDP::Wyslij(const char *serwer, const int port, const char *dane, int dlugosc)
{
    hostent *host;
	sockaddr_in sin;
	memset( &sin, 0, sizeof(sin));

	host=gethostbyname(serwer);

	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = ((struct in_addr *)(host->h_addr))->s_addr;
	sin.sin_port = htons(port); 


	int n = sendto(mojSocket,dane,dlugosc,0,(sockaddr*)&sin,sizeof(sin));

    return n;
}

void CSocketServerUDP::OdbierzDane(const int port, CEdit &edit)
{
	 sockaddr_in sin;
     sockaddr_in klientAdr;
     int rozmiar = sizeof(klientAdr);
     char bufor[1024];
	 wchar_t buforWide[1024];

     sin.sin_addr.s_addr = htonl(INADDR_ANY);
     sin.sin_family = AF_INET;
     sin.sin_port = htons(port);

     if(bind(mojSocket,(const sockaddr*)&sin,sizeof(sin)) == SOCKET_ERROR)
	 {
		 MessageBox(0,L"Bd funkcji bind",L"",MB_OK);
		 return ;
	 }

	 int n = recvfrom(mojSocket,bufor,sizeof(bufor),0,(sockaddr*)&klientAdr,&rozmiar);

	 mbstowcs(buforWide,bufor,n);

	 edit.SetWindowTextW(buforWide);
}